<?php
// download_update_report.php
session_start();
include 'layouts/dbconn.php';
require_once 'fpdf/fpdf.php';

// Check auth
if (!isset($_SESSION['user_id']) || $_SESSION['role_id'] !== 1) {
    die("Access Denied");
}

class PDF extends FPDF
{
    function Header()
    {
        $this->SetFont('Arial', 'B', 15);
        $this->Cell(0, 10, 'MediSure360 - System Update Report', 0, 1, 'C');
        $this->Ln(5);
        $this->SetFont('Arial', '', 10);
        $this->Cell(0, 10, 'Generated on: ' . date('d M Y H:i'), 0, 1, 'R');
        $this->Line(10, 30, 200, 30);
        $this->Ln(10);
    }

    function Footer()
    {
        $this->SetY(-15);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(0, 10, 'Page ' . $this->PageNo() . '/{nb}', 0, 0, 'C');
    }

    function SectionTitle($title)
    {
        $this->SetFont('Arial', 'B', 12);
        $this->SetFillColor(240, 240, 240);
        $this->Cell(0, 8, $title, 0, 1, 'L', true);
        $this->Ln(2);
    }
}

$updateId = $_GET['id'] ?? null;

if (!$updateId) {
    die("Update ID required");
}

// Fetch Data
$sql = "SELECT u.*, us.username 
        FROM system_updates u
        LEFT JOIN users us ON u.installed_by = us.user_id
        WHERE u.update_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param('i', $updateId);
$stmt->execute();
$result = $stmt->get_result();
$update = $result->fetch_assoc();

if (!$update) {
    die("Update not found");
}

$pdf = new PDF();
$pdf->AliasNbPages();
$pdf->AddPage();

// Version Info
$pdf->SectionTitle('Update Information');
$pdf->SetFont('Arial', 'B', 10);
$pdf->Cell(40, 7, 'Version:', 0);
$pdf->SetFont('Arial', '', 10);
$pdf->Cell(0, 7, $update['version'], 0, 1);

$pdf->SetFont('Arial', 'B', 10);
$pdf->Cell(40, 7, 'Status:', 0);
$pdf->SetFont('Arial', '', 10);
$pdf->Cell(0, 7, $update['status'], 0, 1);

$pdf->SetFont('Arial', 'B', 10);
$pdf->Cell(40, 7, 'Release Date:', 0);
$pdf->SetFont('Arial', '', 10);
$pdf->Cell(0, 7, $update['release_date'], 0, 1);

$pdf->SetFont('Arial', 'B', 10);
$pdf->Cell(40, 7, 'Installed Date:', 0);
$pdf->SetFont('Arial', '', 10);
$pdf->Cell(0, 7, $update['installed_date'], 0, 1);

$pdf->SetFont('Arial', 'B', 10);
$pdf->Cell(40, 7, 'Installed By:', 0);
$pdf->SetFont('Arial', '', 10);
$pdf->Cell(0, 7, $update['username'] ?? 'System', 0, 1);

$pdf->Ln(5);

// Checksum
if ($update['checksum']) {
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(40, 7, 'Checksum:', 0);
    $pdf->SetFont('Courier', '', 9);
    $pdf->MultiCell(0, 7, $update['checksum']);
    $pdf->Ln(5);
}

// Changelog
$pdf->SectionTitle('Changelog');
$pdf->SetFont('Arial', '', 10);
$pdf->MultiCell(0, 6, $update['description'] ?? 'No description provided.');
$pdf->Ln(5);

// Files
$files = !empty($update['update_files']) ? json_decode($update['update_files'], true) : [];
if (!empty($files)) {
    $pdf->SectionTitle('Included Files');
    $pdf->SetFont('Courier', '', 9);
    foreach ($files as $file) {
        $pdf->Cell(0, 5, '- ' . $file, 0, 1);
    }
    $pdf->Ln(5);
}

// DB Changes
$db_changes = !empty($update['db_changes']) ? json_decode($update['db_changes'], true) : [];
if (!empty($db_changes)) {
    $pdf->SectionTitle('Database Changes');
    $pdf->SetFont('Courier', '', 9);
    foreach ($db_changes as $change) {
        $str = is_array($change) ? json_encode($change) : $change;
        $pdf->MultiCell(0, 5, '- ' . $str);
    }
}

$pdf->Output('D', 'Update_Report_' . $update['version'] . '.pdf');
exit;
