<?php
/**
 * MobileMoneyGateway.php
 * Interface for mobile money payments (M-Pesa, Airtel Money).
 */
class MobileMoneyGateway
{
    private $provider; // 'MPESA', 'AIRTEL'
    private $apiKey;

    public function __construct($provider = 'MPESA')
    {
        $this->provider = $provider;
        // In a real app, load credentials from env or config
        $this->apiKey = 'MOCK_KEY';
    }

    /**
     * Initiate a STK Push (Lipa Na M-Pesa Online)
     * 
     * @param string $phoneNumber Format: 2547XXXXXXXX
     * @param float $amount
     * @param string $accountReference
     * @return array Response
     */
    public function requestPayment($phoneNumber, $amount, $accountReference)
    {
        // Mock logic for demonstration
        return [
            'success' => true,
            'checkout_request_id' => 'ws_CO_' . time() . uniqid(),
            'message' => 'Customer received STK push'
        ];
    }

    /**
     * Verify a transaction status
     */
    public function verifyTransaction($checkoutRequestId)
    {
        // Mock verification
        return [
            'status' => 'COMPLETED',
            'amount' => 500,
            'receipt' => 'QWE123RTY'
        ];
    }
}
?>